/*:
 * @target MZ
 * @plugindesc えちけむりを充満させる
 * @author 肴酒
 *
 * @help
 * えちけむりを充満させる
 */

(() => {
  "use strict";


/**
 * Destroys the weather.
 */
Weather.prototype.destroy = function() {
    const options = { children: true, texture: true };
    PIXI.Container.prototype.destroy.call(this, options);
    this._rainBitmap.destroy();
    this._stormBitmap.destroy();
  //this._snowBitmap.destroy();
    };

/**
 * Updates the weather for each frame.
 */
Weather.prototype.update = function() {
    this._updateDimmer();
    this._updateAllSprites();
};

Weather.prototype._createBitmaps = function() {
    this._rainBitmap = new Bitmap(1, 60);
    this._rainBitmap.fillAll("white");
    this._stormBitmap = new Bitmap(2, 100);
    this._stormBitmap.fillAll("white");
    this._snowBitmap = ImageManager.loadSystem('UEK');
};

})();
